#!/bin/bash
echo "🔧 Auto-fix casts datetime yang salah jadi array..."
echo

# Cari semua model yang nge-cast datetime
grep -Rl "datetime" app/Models | while read -r file ; do
    echo "⚙️  Memperbaiki $file ..."
    # Backup dulu sebelum ubah
    cp "$file" "$file.bak"

    # Ubah semua 'datetime' jadi 'array' kecuali created_at, updated_at, deleted_at
    sed -i 's/\("created_at"[[:space:]]*=>[[:space:]]*"datetime"\)/\1/g' "$file"
    sed -i 's/\("updated_at"[[:space:]]*=>[[:space:]]*"datetime"\)/\1/g' "$file"
    sed -i 's/\("deleted_at"[[:space:]]*=>[[:space:]]*"datetime"\)/\1/g' "$file"
    sed -i 's/"datetime"/"array"/g' "$file"

done

echo
echo "✅ Semua model sudah di-scan dan diubah (backup disimpan *.bak)"
